<div class="woodmart-feedback-container">
    <div class="feedback-header">
        <h2><?php esc_html_e('بازخورد محصولات', 'woodmartplus'); ?></h2>
    </div>

    <!-- تب‌ها -->
    <div class="feedback-tabs">
        <div class="tab-navigation">
            <button class="tab-btn active" data-tab="no-feedback"><?php esc_html_e('محصولات بدون بازخورد', 'woodmartplus'); ?></button>
            <button class="tab-btn" data-tab="with-feedback"><?php esc_html_e('محصولات با بازخورد', 'woodmartplus'); ?></button>
        </div>
        
        <!-- تب محصولات بدون بازخورد -->
        <div class="tab-content active" id="no-feedback-tab">
            <div class="products-list">
                <?php foreach ($products_without_feedback as $product): ?>
                    <div class="product-item">
                        <div class="product-info">
                            <div class="product-image">
                                <img src="<?php echo esc_url($product['product_image_url']) ?>" alt="<?php echo esc_attr($product['product_name']); ?>">
                            </div>
                            <div class="product-details">
                                <h3 class="product-title">
                                    <a href="<?php echo esc_url($product['product_url']); ?>">
                                        <?php echo esc_html($product['product_name']); ?>
                                    </a>
                                </h3>
                                <div class="product-price">
                                    <?php echo $product['product_price']; ?>
                                </div>
                            </div>
                        </div>
                        <div class="product-rating">
                            <div class="star-rating">
                                <div class="star-rating-container" data-product-id="<?php echo esc_attr($product['product_id']); ?>">
                                    <span class="star" data-rating="1">★</span>
                                    <span class="star" data-rating="2">★</span>
                                    <span class="star" data-rating="3">★</span>
                                    <span class="star" data-rating="4">★</span>
                                    <span class="star" data-rating="5">★</span>
                                </div>
                                <div class="rating-text"><?php esc_html_e('امتیاز دهید', 'woodmartplus'); ?></div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        
        <!-- تب محصولات با بازخورد -->
        <div class="tab-content" id="with-feedback-tab">
            <div class="products-list">
                <?php foreach ($products_with_feedback as $product): ?>
                    <div class="product-item">
                        <!-- محتوای تب دوم بعداً تکمیل می‌شود -->
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
    </div>

    <!-- پاپ‌آپ ثبت بازخورد -->
    <div class="feedback-popup-overlay"></div>
    <div class="feedback-popup">
        <div class="popup-header">
            <h3><?php esc_html_e('ثبت بازخورد', 'woodmartplus'); ?></h3>
            <button class="close-popup">×</button>
        </div>
        <div class="popup-content">
            <div class="feedback-notice">
                <span></span>
            </div>
            <div class="feedback-loader">
                <div class="loader-spinner"></div>
            </div>
            <form id="feedback-form">
                <!-- محتوای فرم با Ajax بارگذاری می‌شود -->
            </form>
        </div>
    </div>
</div>

<style>
    /* استایل‌های کلی */
    .woodmart-feedback-container {
        font-family: 'IRANSans', 'Tahoma', sans-serif;
        max-width: 1200px;
        margin: 0 auto;
        padding: 20px;
        direction: rtl;
    }

    .feedback-header {
        margin-bottom: 30px;
        text-align: center;
    }

    .feedback-header h2 {
        font-size: 24px;
        color: #333;
        margin: 0;
    }

    /* استایل تب‌ها */
    .tab-navigation {
        display: flex;
        border-bottom: 2px solid #eee;
        margin-bottom: 20px;
    }

    .tab-btn {
        padding: 12px 20px;
        background: none;
        border: none;
        font-size: 16px;
        font-weight: 600;
        color: #666;
        cursor: pointer;
        position: relative;
        transition: all 0.3s ease;
    }

    .tab-btn:focus {
        outline: none;
    }

    .tab-btn.active {
        color: #d85454;
    }

    .tab-btn.active:after {
        content: '';
        position: absolute;
        bottom: -2px;
        left: 0;
        width: 100%;
        height: 2px;
        background-color: #d85454;
    }

    .tab-content {
        display: none;
    }

    .tab-content.active {
        display: block;
    }

    /* استایل لیست محصولات */
    .products-list {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 20px;
    }

    .product-item {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 15px;
        border-radius: 8px;
        box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);
        background-color: #fff;
        transition: transform 0.3s ease, box-shadow 0.3s ease;
    }

    .product-item:hover {
        transform: translateY(-3px);
        box-shadow: 0 4px 12px rgba(0, 0, 0, 0.15);
    }

    .product-info {
        display: flex;
        align-items: center;
        flex: 1;
    }

    .product-image {
        width: 80px;
        height: 80px;
        overflow: hidden;
        border-radius: 6px;
        margin-left: 15px;
    }

    .product-image img {
        width: 100%;
        height: 100%;
        object-fit: cover;
    }

    .product-details {
        flex: 1;
    }

    .product-title {
        font-size: 16px;
        margin: 0 0 8px 0;
    }

    .product-title a {
        color: #333;
        text-decoration: none;
        transition: color 0.3s ease;
    }

    .product-title a:hover {
        color: #d85454;
    }

    .product-price {
        font-size: 14px;
        color: #d85454;
        font-weight: 600;
    }

    /* استایل امتیازدهی */
    .product-rating {
        min-width: 150px;
        text-align: center;
    }

    .star-rating {
        display: inline-block;
    }

    .star-rating-container {
        direction: ltr;
        display: inline-block;
        unicode-bidi: bidi-override;
    }

    .star {
        color: #ddd;
        font-size: 24px;
        cursor: pointer;
        transition: color 0.2s ease;
        display: inline-block;
    }

    .star:hover,
    .star.active {
        color: #FFD700;
    }

    .star-rating-container:hover .star {
        color: #ddd;
    }

    .star-rating-container .star:hover ~ .star {
        color: #ddd;
    }

    .star-rating-container:hover .star:hover,
    .star-rating-container:hover .star:hover ~ .star {
        color: #FFD700;
    }

    .rating-text {
        margin-top: 5px;
        font-size: 12px;
        color: #666;
    }

    /* استایل بازخورد محصولات */
    .product-feedback {
        min-width: 200px;
        padding: 10px;
        border-right: 1px solid #eee;
        margin-right: 15px;
    }

    .feedback-rating {
        display: flex;
        justify-content: space-between;
        align-items: center;
        margin-bottom: 10px;
    }

    .rating-stars {
        direction: ltr;
        display: inline-block;
    }

    .rating-stars .star {
        color: #ddd;
        font-size: 18px;
        display: inline-block;
    }

    .rating-stars .star.active {
        color: #FFD700;
    }

    .feedback-date {
        font-size: 12px;
        color: #888;
    }

    .feedback-text {
        font-size: 13px;
        color: #555;
        line-height: 1.5;
    }

    .feedback-text p {
        margin: 0;
    }

    /* استایل برای حالت موبایل */
    @media (max-width: 768px) {
        .products-list {
            grid-template-columns: 1fr;
        }
        
        .product-item {
            flex-direction: column;
            align-items: flex-start;
        }
        
        .product-rating, .product-feedback {
            width: 100%;
            margin-top: 15px;
            padding: 0;
            border-right: none;
            border-top: 1px solid #eee;
            padding-top: 15px;
        }
    }

    /* استایل برای فرم بازخورد در پاپ‌آپ */
    #feedback-form {
        width: 100%;
    }

    .form-group {
        margin-bottom: 15px;
    }

    .form-group label {
        display: block;
        margin-bottom: 5px;
        font-weight: 600;
        font-size: 14px;
    }

    .form-group input,
    .form-group textarea {
        width: 100%;
        padding: 10px;
        border: 1px solid #ddd;
        border-radius: 4px;
        font-family: inherit;
    }

    .form-group textarea {
        min-height: 100px;
        resize: vertical;
    }

    .form-submit {
        text-align: left;
    }

    .btn-submit {
        background-color: #d85454;
        color: white;
        border: none;
        padding: 10px 20px;
        border-radius: 4px;
        cursor: pointer;
        font-weight: 600;
        transition: background-color 0.3s ease;
    }

    .btn-submit:hover {
        background-color: #c04545;
    }

    /* استایل برای ستاره‌های هاور */
    .star.hover {
        color: #FFD700;
    }

    /* استایل پاپ‌آپ */
    .feedback-popup-overlay {
        position: fixed;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: rgba(0, 0, 0, 0.5);
        z-index: 1000;
        display: none;
    }

    .feedback-popup {
        position: fixed;
        top: 50%;
        left: 50%;
        transform: translate(-50%, -50%);
        background-color: #fff;
        border-radius: 8px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.2);
        width: 500px;
        max-width: 90%;
        max-height: 90vh;
        overflow-y: auto;
        z-index: 1001;
        display: none;
    }

    .popup-header {
        display: flex;
        justify-content: space-between;
        align-items: center;
        padding: 15px 20px;
        border-bottom: 1px solid #eee;
    }

    .popup-header h3 {
        margin: 0;
        font-size: 18px;
    }

    .close-popup {
        background: none;
        border: none;
        font-size: 24px;
        cursor: pointer;
        color: #666;
    }

    .popup-content {
        padding: 20px;
        position: relative;
    }

    .feedback-notice {
        margin-bottom: 15px;
    }

    .feedback-notice span {
        display: block;
        padding: 10px;
        border-radius: 4px;
        font-size: 14px;
    }

    .feedback-notice.success span {
        background-color: #e8f5e9;
        color: #2e7d32;
    }

    .feedback-notice.error span {
        background-color: #ffebee;
        color: #c62828;
    }

    .feedback-loader {
        position: absolute;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: rgba(255, 255, 255, 0.8);
        display: flex;
        justify-content: center;
        align-items: center;
        z-index: 1;
        display: none;
    }

    .loader-spinner {
        width: 40px;
        height: 40px;
        border: 4px solid #f3f3f3;
        border-top: 4px solid #d85454;
        border-radius: 50%;
        animation: spin 1s linear infinite;
    }

    @keyframes spin {
        0% { transform: rotate(0deg); }
        100% { transform: rotate(360deg); }
    }
</style>

<script>
    jQuery(document).ready(function($) {
        // مدیریت تب‌ها
        $('.tab-btn').on('click', function() {
            $('.tab-btn').removeClass('active');
            $('.tab-content').removeClass('active');
            
            $(this).addClass('active');
            var tabId = $(this).data('tab');
            $('#' + tabId + '-tab').addClass('active');
        });

        // مدیریت امتیازدهی
        $('.star').on('click', function() {
            var $container = $(this).closest('.star-rating-container');
            var productId = $container.data('product-id');
            var rating = $(this).data('rating');
            
            // فعال کردن ستاره‌های انتخاب شده
            $container.find('.star').removeClass('active');
            $container.find('.star').each(function() {
                if ($(this).data('rating') <= rating) {
                    $(this).addClass('active');
                }
            });
            
            // نمایش پاپ‌آپ ثبت بازخورد
            showFeedbackPopup(productId, rating);
        });

        // نمایش پاپ‌آپ ثبت بازخورد
        function showFeedbackPopup(productId, rating) {
            $('.feedback-popup-overlay, .feedback-popup').show();
            $('.feedback-loader').show();
            
            // ارسال درخواست Ajax برای دریافت فرم بازخورد
            $.ajax({
                url: woodmart_settings.ajaxurl,
                type: 'POST',
                data: {
                    action: 'get_product_feedback_form',
                    product_id: productId,
                    rating: rating,
                    security: woodmart_settings.nonce
                },
                success: function(response) {
                    $('.feedback-loader').hide();
                    $('#feedback-form').html(response);
                },
                error: function() {
                    $('.feedback-loader').hide();
                    $('.feedback-notice').addClass('error').find('span').text('خطا در بارگذاری فرم بازخورد');
                }
            });
        }

        // بستن پاپ‌آپ
        $('.close-popup, .feedback-popup-overlay').on('click', function() {
            $('.feedback-popup-overlay, .feedback-popup').hide();
            $('#feedback-form').html('');
            $('.feedback-notice').removeClass('success error').find('span').text('');
        });

        // ارسال فرم بازخورد
        $(document).on('submit', '#feedback-form', function(e) {
            e.preventDefault();
            
            $('.feedback-loader').show();
            
            $.ajax({
                url: woodmart_settings.ajaxurl,
                type: 'POST',
                data: $(this).serialize() + '&action=submit_product_feedback&security=' + woodmart_settings.nonce,
                success: function(response) {
                    $('.feedback-loader').hide();
                    
                    if (response.success) {

                        $('.feedback-notice').addClass('success').find('span').text(response.data.message);
                        
                        // پاک کردن فرم
                        $('#feedback-form').html('');
                        
                        // بروزرسانی صفحه بعد از چند ثانیه
                        setTimeout(function() {
                            location.reload();
                        }, 2000);
                    } else {
                        $('.feedback-notice').addClass('error').find('span').text(response.data.message);
                    }
                },
                error: function() {
                    $('.feedback-loader').hide();
                    $('.feedback-notice').addClass('error').find('span').text('خطا در ارسال بازخورد');
                }
            });
        });

        // پیش‌نمایش امتیازدهی با هاور
        $('.star-rating-container').each(function() {
            var $container = $(this);
            var $stars = $container.find('.star');
            
            // حالت هاور برای ستاره‌ها
            $stars.hover(
                function() {
                    var rating = $(this).data('rating');
                    
                    // روشن کردن ستاره‌های قبل از ستاره هاور شده
                    $stars.each(function() {
                        if ($(this).data('rating') <= rating) {
                            $(this).addClass('hover');
                        } else {
                            $(this).removeClass('hover');
                        }
                    });
                },
                function() {
                    // حذف کلاس هاور از همه ستاره‌ها
                    $stars.removeClass('hover');
                }
            );
        });
    });
</script>