<?php


if (! defined('ABSPATH')) {
	exit;
}

do_action('woocommerce_before_account_navigation');

// $menus = wc_get_account_menu_items();

global $WooWcWallet;

$user_id = get_current_user_id();
$attachment_id = get_user_meta($user_id, '_acount_image', true);
$last_name = get_user_meta($user_id, 'last_name', true);
$first_name = get_user_meta($user_id, 'first_name', true);

$note = __('اطلاعات خود را کامل کنید', 'woodmartplus');

$phone = get_user_meta($user_id, PHONEMETA, true) ? get_user_meta($user_id, PHONEMETA, true) : false;
if (!$phone) {
	$phone = get_user_meta($user_id, 'digits_phone_no', true) ?  get_user_meta($user_id, 'digits_phone_no', true) : false;
}
$full_name = isset($first_name) && !empty($first_name) ? $first_name . ' ' . $last_name : $note;

$original_image_url = wp_get_attachment_url($attachment_id);
?>
<div class="dashboard_side">
	<a href="<?php echo wc_logout_url(); ?>" class="signout_button">
		<p><?php esc_html_e('خروج', 'woodmartplus'); ?></p>
		<i class="fa-light fa-arrow-right-from-bracket-advanced"></i>
	</a>
	<div class="justify_end"></div>

	<div class="dashboard_avatar avatar_image_account">
		<?php if ($original_image_url): ?>
			<img src="<?php echo wp_get_attachment_image_url($attachment_id, 'full'); ?>" alt="user avatar">
		<?php else: ?>
			<img src="<?php echo WOODPLUS_ASSET . 'img/' ?>user.svg" alt="user avatar">
		<?php endif; ?>
	</div>

	<div class="gap-y">
		<div class="justify_end">
			<a href="<?php echo esc_url(wc_get_endpoint_url('edit-account'));  ?>" class="link_gray small">
				<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none">
					<path d="M6.41699 1.16663H5.25033C2.33366 1.16663 1.16699 2.33329 1.16699 5.24996V8.74996C1.16699 11.6666 2.33366 12.8333 5.25033 12.8333H8.75033C11.667 12.8333 12.8337 11.6666 12.8337 8.74996V7.58329" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"></path>
					<path d="M9.35708 1.76169L4.76042 6.35836C4.58542 6.53336 4.41042 6.87753 4.37542 7.12836L4.12458 8.88419C4.03125 9.52002 4.48042 9.96336 5.11625 9.87586L6.87208 9.62503C7.11708 9.59003 7.46125 9.41503 7.64208 9.24003L12.2388 4.64336C13.0321 3.85003 13.4054 2.92836 12.2388 1.76169C11.0721 0.595025 10.1504 0.968359 9.35708 1.76169Z" stroke="currentColor" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
					<path d="M8.69727 2.42078C9.0881 3.81494 10.1789 4.90578 11.5789 5.30244" stroke="currentColor" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
				</svg>
				<p><?php esc_html_e('ویرایش اطلاعات', 'woodmartplus'); ?></p>
			</a>
		</div>
		<div class="badge_gray space_between">
			<p><?php echo esc_html($full_name); ?></p>
			<p class="font_semibold"><?php echo $phone ? esc_html_e($phone) : '<a href=" ' . esc_url(wc_get_endpoint_url('edit-account')) . ' " >' . __('اضافه کردن شماره موبایل', 'woodmartplus') . '</a>'; ?></p>
		</div>
		<?php if( !is_null( $WooWcWallet ) ): ?>
		<div class="badge_gray space_between">
			<p><?php echo esc_html_e('موجودی کیف پول','woodmartplus'); ?></p>
			<p class="font_semibold"><?php echo wc_price( $WooWcWallet->get_count_wallet() );  ?></p>
		</div>
		<?php endif; ?>
	</div>
	<div class="dashboard_side__body">
		<ul class="dashboard_menu">
			<?php foreach ($menus as $value) : ?>

				<li class="dashboard_menu__item <?php echo wc_get_account_menu_item_classes(urldecode($value['select_menu'])); ?>">
					<div class="gap-x">
						<div class="icon">
							<?php \Elementor\Icons_Manager::render_icon($value['icon_menu'], ['aria-hidden' => 'true']); ?>
						</div>
						<p><a href="<?php echo esc_url(wc_get_account_endpoint_url($value['select_menu'])); ?>"><?php echo esc_html($value['title_menu']); ?></a></p>
					</div>
					<div class="arrow_button">
						<i class="fa-regular fa-arrow-left"></i>
					</div>
				</li>

			<?php endforeach; ?>
		</ul>
		<a href="<?php echo wc_logout_url(); ?>" class="btn solid medium"><?php esc_html_e('خروج', 'woodmartplus'); ?></a>
	</div>
</div>
<?php do_action('woocommerce_after_account_navigation'); ?>