<?php
$image_detial = wplus_helper::get_background_img_color_login('logo_login_register_layout_3') ? 'style="background-image:url(' . esc_url(wplus_helper::get_background_img_color_login('logo_login_register_layout_3')) . ')"' : '';
?>
<div class="background-wrapper">

    <div class="container_login_register_layout2">

        <div class="wplus-row">
            <div class="close__section layout-2">
                <a class="close__section___btn" href="<?php echo esc_url(home_url()); ?>">
                    <i class="fa-solid fa-x"></i>
                </a>
            </div>
            <div class="wplus__top_row">
                <div class="right__section__register layout-2">
                    <div class="logo__section layout-2">
                        <img src="<?php echo wplus_helper::get_logo_login_register(WOODPLUS_ASSET . 'img/default-logo.png'); ?>" alt="logo">
                    </div>


                    <div class="login_register__body">

                        <form class="form__login_register" method="POST">
                            <p class="login_register___text"> <?php echo esc_html(wplus_helper::get_setting('title_login_register')); ?></p>
                            <p class="login_register__description"><?php echo esc_html(wplus_helper::get_setting('after_title_text')); ?></p>

                            <div class="login_register__input">

                                <input type="text" name="username" placeholder="<?php echo wplus_helper::get_setting('first_placeholder', 'ایمیل / موبایل / نام کاربری') ?>">

                                <i class="fa-thin fa-lock"></i>
                            </div>
                            <button type="submit" class="login_register__submitbtn">
                                <i class="icon-button fa-regular fa-user-plus"></i>
                                <?php echo wplus_helper::get_setting('first_btn_text', 'ثبت نام / ورود') ?>
                            </button>

                            <?php if (woodplus_Recaptcha::is_recaptcha_enabled() && wplus_helper::get_setting('setting_recaptcha_enable')) { ?>
                                <div id="recaptcha-contact-form" class="ga-recaptcha" data-sitekey="<?php echo esc_attr(wplus_helper::get_setting('google_recaptcha_site_key')); ?>"></div>
                            <?php } ?>

                            <p class="login_register__description_after_btn">
                                <?php echo wplus_helper::generate_terms_condition(); ?>
                            </p>
                            <p class="login_register__description_after_btn">
                                <a href="<?php echo esc_url(wp_lostpassword_url()); ?>" class="text_blue">
                                    <?php echo wplus_helper::get_setting('first_text_forgetpassword', __('Lost your password?', 'woodmartplus')) ?>
                                </a>
                            </p>
                            <?php
                            wp_nonce_field('form_login_register', 'nonce_login_register');
                            ?>

                        </form>

                        <form class="form_login_email" style="display: none;">

                            <p class="login_register___text"> <?php echo esc_html(wplus_helper::get_setting('title_login_register', 'ثبت نام / ورود ')); ?> </p>
                            <p class="login_register__description"><?php echo wplus_helper::get_setting('two_title_text', 'رمزعبور ایمیل خود را وارد کنید') ?></p>
                            <div class="login_register__input">
                                <input type="password" name="password" placeholder="<?php echo wplus_helper::get_setting('two_placeholder_text', 'رمز عبور') ?>">
                                <i class="fa-thin fa-lock"></i>
                            </div>
                            <button type="submit" class="login_register__submitbtn">
                                <i class="icon-button fa-regular fa-user-plus"></i>
                                <?php echo wplus_helper::get_setting('two_btn_text', 'ورود') ?>
                            </button>
                            <p class="login_register__description_after_btn">
                                <?php echo wplus_helper::generate_terms_condition(); ?>
                            </p>
                            <?php
                            wp_nonce_field('form_login_with_email', 'nonce_login_email');
                            ?>
                        </form>

                        <form class="form_register_email" style="display: none;">

                            <p class="login_register___text"> <?php echo esc_html(wplus_helper::get_setting('title_login_register', 'ثبت نام / ورود ')); ?> </p>
                            <p class="login_register__description"><?php echo esc_html(wplus_helper::get_setting('after_title_text')); ?></p>

                            <div class="login_register__input">
                                <input type="text" name="username" placeholder="<?php echo wplus_helper::get_setting('three_placeholder_username', 'نام‌کاربری') ?>">
                                <i class="fa-thin fa-lock"></i>
                            </div>

                            <div class="login_register__input">
                                <input type="password" name="password" placeholder="<?php echo wplus_helper::get_setting('three_placeholder_password', 'رمزعبور') ?>">
                                <i class="fa-thin fa-lock"></i>
                            </div>

                            <button type="submit" class="login_register__submitbtn">
                                <i class="icon-button fa-regular fa-user-plus"></i>
                                <?php echo wplus_helper::get_setting('three_btn_text', 'ثبت نام') ?>
                            </button>
                            <p class="login_register__description_after_btn">
                                <?php echo wplus_helper::generate_terms_condition(); ?>
                            </p>
                            <?php
                            wp_nonce_field('form_register_with_email', 'nonce_register_email');
                            ?>
                        </form>

                        <form class="login_register_otp" style="display: none;">

                            <p class="login_register___text"> <?php echo esc_html(wplus_helper::get_setting('title_login_register', 'ثبت نام / ورود ')); ?> </p>

                            <div class="gap-x">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
                                    <path d="M6.375 14.25H6C3 14.25 1.5 13.5 1.5 9.75V6C1.5 3 3 1.5 6 1.5H12C15 1.5 16.5 3 16.5 6V9.75C16.5 12.75 15 14.25 12 14.25H11.625C11.3925 14.25 11.1675 14.3625 11.025 14.55L9.9 16.05C9.405 16.71 8.595 16.71 8.1 16.05L6.975 14.55C6.855 14.385 6.5775 14.25 6.375 14.25Z" stroke="#5E5E5E" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M11.9973 8.25H12.0041" stroke="#5E5E5E" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M8.99661 8.25H9.00335" stroke="#5E5E5E" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M5.99588 8.25H6.00262" stroke="#292D32" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                                </svg>
                                <p class="msg_detail_number"> </p>
                            </div>

                            <div class="otp_input__grid" dir="ltr">
                                <?php for ($i = 0; $i < $number_digits; $i++): ?>
                                    <div class="otp_input__container solid_input">
                                        <input type="text" class="otp-input" maxlength="1" dir="ltr">
                                    </div>
                                <?php endfor; ?>
                            </div>
                            <div class="space_between">
                                <p><?php echo wplus_helper::get_setting('four_timeup_text', 'زمان باقی مانده:') ?><span class="time_resend"></span></p>
                                <button type="button" class="text_blue edit_number">
                                    <?php echo wplus_helper::get_setting('four_editnumber', 'ویرایش شماره') ?>
                                </button>
                            </div>
                            <button type="submit" class="login_register__submitbtn">
                                <i class="icon-button fa-regular fa-user-plus"></i>
                                <?php echo wplus_helper::get_setting('four_btn_text', 'تایید موبایل') ?>
                            </button>
                            <p class="login_register__description_after_btn">
                                <?php echo wplus_helper::generate_terms_condition(); ?>
                            </p>
                            <?php
                            wp_nonce_field('form_verify_otp', 'nonce_verify_otp');
                            ?>
                        </form>

                        <form class="login_register_otp_email" style="display: none;">

                            <p class="login_register___text"> <?php echo esc_html(wplus_helper::get_setting('title_login_register', 'ثبت نام / ورود ')); ?> </p>

                            <div class="gap-x">
                                <svg xmlns="http://www.w3.org/2000/svg" width="18" height="18" viewBox="0 0 18 18" fill="none">
                                    <path d="M6.375 14.25H6C3 14.25 1.5 13.5 1.5 9.75V6C1.5 3 3 1.5 6 1.5H12C15 1.5 16.5 3 16.5 6V9.75C16.5 12.75 15 14.25 12 14.25H11.625C11.3925 14.25 11.1675 14.3625 11.025 14.55L9.9 16.05C9.405 16.71 8.595 16.71 8.1 16.05L6.975 14.55C6.855 14.385 6.5775 14.25 6.375 14.25Z" stroke="#5E5E5E" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M11.9973 8.25H12.0041" stroke="#5E5E5E" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M8.99661 8.25H9.00335" stroke="#5E5E5E" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                                    <path d="M5.99588 8.25H6.00262" stroke="#292D32" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                                </svg>
                                <p class="msg_detail_number"> </p>
                            </div>

                            <div class="otp_input__grid" dir="ltr">
                                <?php for ($i = 0; $i < $number_digits; $i++): ?>
                                    <div class="otp_input__container solid_input">
                                        <input type="text" class="otp-input" maxlength="1" dir="ltr">
                                    </div>
                                <?php endfor; ?>
                            </div>
                            <div class="space_between">
                                <p><?php echo wplus_helper::get_setting('five_timeup_text', 'زمان باقی مانده:') ?><span class="time_resend"></span></p>
                            </div>
                            <button type="submit" class="login_register__submitbtn">
                                <i class="icon-button fa-regular fa-user-plus"></i>
                                <?php echo wplus_helper::get_setting('five_btn_text', 'تایید ایمیل') ?>
                            </button>
                            <p class="login_register__description_after_btn">
                                <?php echo wplus_helper::generate_terms_condition(); ?>
                            </p>
                            <?php
                            wp_nonce_field('form_verify_otp_email', 'nonce_verify_otp_email');
                            ?>
                        </form>

                    </div>
                </div>
                <div class="left__section layout-2" <?php echo $image_detial; ?>>
                </div>
            </div>

            <?php if (wplus_helper::get_setting('more_description_login_register')): ?>
                <div class="wplus__bottom_row">
                    <p>
                        <?php echo esc_html(wplus_helper::get_setting('more_description_login_register')); ?>
                    </p>
                </div>
            <?php endif; ?>
        </div>

    </div>

</div>