<div class="export-import-settings">
    <div class="settings-section">
        <h3 class="section-title"><?php esc_html_e('درون ریزی / برون بری تنظیمات', 'woodmartplus'); ?></h3>
        <p class="section-description"><?php esc_html_e('تنظیمات وودمارت پلاس را میتوانید به صورت فایل برون بری بگیرید و یا فایل های برون‌بری قبلی را درون ریزی کنید', 'woodmartplus'); ?></p>
        
        <div class="export-import-container">
            <!-- Export Section -->
            <div class="export-section">
                <div class="export-header">
                    <div class="export-icon">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M12 15L12 3M12 15L8 11M12 15L16 11" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M20 12V19C20 20.1046 19.1046 21 18 21H6C4.89543 21 4 20.1046 4 19V12" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </div>
                    <div class="export-content">
                        <h4><?php esc_html_e('برون بری تنظیمات', 'woodmartplus'); ?></h4>
                        <p><?php esc_html_e('دریافت فایل json تنظیمات', 'woodmartplus'); ?></p>
                    </div>
                </div>
                <a type="button" class="export-btn" id="export-settings-btn" href="<?php echo esc_url( admin_url( 'admin-ajax.php' ) ); ?>?action=wdplus_download_export_options">
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M21 15V19C21 20.1046 20.1046 21 19 21H5C3.89543 21 3 20.1046 3 19V15" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M7 10L12 15L17 10" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M12 15V3" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                    <?php esc_html_e('برون بری', 'woodmartplus'); ?>
                </a>
            </div>

            <!-- Divider -->
            <div class="divider">
                <span><?php esc_html_e('یا', 'woodmartplus'); ?></span>
            </div>

            <!-- Import Section -->
            <div class="import-section">
                <div class="import-header">
                    <div class="import-icon">
                        <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M21 15V19C21 20.1046 20.1046 21 19 21H5C3.89543 21 3 20.1046 3 19V15" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M7 10L12 15L17 10" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            <path d="M12 15V3" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </div>
                    <div class="import-content">
                        <h4><?php esc_html_e('درون ریزی تنظیمات', 'woodmartplus'); ?></h4>
                        <p><?php esc_html_e('فایل json تنظیمات خود را آپلود کنید', 'woodmartplus'); ?></p>
                    </div>
                </div>
                
                <div class="file-upload-area" id="file-upload-area">
                    <div class="upload-content">
                        <div class="upload-icon">
                            <svg width="48" height="48" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M14 2H6C4.89543 2 4 2.89543 4 4V20C4 21.1046 4.89543 22 6 22H18C19.1046 22 20 21.1046 20 20V8L14 2Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M14 2V8H20" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M16 13H8" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M16 17H8" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M10 9H8" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <div class="upload-text">
                            <h5><?php esc_html_e('انتخاب فایل یا کشیدن و رها کردن', 'woodmartplus'); ?></h5>
                            <p><?php esc_html_e('فایل json تنظیمات خود را در این قسمت قرار دهید', 'woodmartplus'); ?></p>
                            <span class="file-types"><?php esc_html_e('فرمت فایل: .json', 'woodmartplus'); ?></span>
                        </div>
                    </div>
                </div>
                    <input type="file" id="import-file-input" name="import-file-input" accept=".json" style="display: none;">
                <div class="selected-file" id="selected-file" style="display: none;">
                    <div class="file-info">
                        <div class="file-icon">
                            <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M14 2H6C4.89543 2 4 2.89543 4 4V20C4 21.1046 4.89543 22 6 22H18C19.1046 22 20 21.1046 20 20V8L14 2Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                <path d="M14 2V8H20" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </div>
                        <div class="file-details">
                            <span class="file-name" id="file-name"></span>
                            <span class="file-size" id="file-size"></span>
                        </div>
                        <button type="button" class="remove-file-btn" id="remove-file-btn">
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                <path d="M18 6L6 18M6 6L18 18" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </button>
                    </div>
                </div>

                <button type="button" name="woodmartplus_import_options" value="1" class="import-btn" id="import-settings-btn" disabled>
                    <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M12 15L12 3M12 15L8 11M12 15L16 11" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        <path d="M20 12V19C20 20.1046 19.1046 21 18 21H6C4.89543 21 4 20.1046 4 19V12" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                    </svg>
                    <?php esc_html_e('درون ریزی', 'woodmartplus'); ?>
                </button>
            </div>
        </div>

        <!-- Warning Message -->
        <div class="warning-message">
            <div class="warning-icon">
                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M12 9V13M12 17H12.01M21 12C21 16.9706 16.9706 21 12 21C7.02944 21 3 16.9706 3 12C3 7.02944 7.02944 3 12 3C16.9706 3 21 7.02944 21 12Z" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                </svg>
            </div>
            <div class="warning-content">
                <h5><?php esc_html_e('اخطار مهم', 'woodmartplus'); ?></h5>
                <p><?php esc_html_e('درونریزی تنظیمات، پیکربندی فعلی شما را بازنویسی می‌کند. قبل از درون ریزی تنظیمات تنظیمات جدید، حتماً تنظیمات فعلی خود را برون بری بگیرید.', 'woodmartplus'); ?></p>
            </div>
        </div>
    </div>
</div>


