<div class="item p-18 br-bottom">
    <span class="title"><?php esc_html_e('فعال کردن سیستم باز خورد', 'woodmartplus'); ?></span>
    <p class="des"></p>
    <div class="btn-select">
        <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[enable_feedback_system]'); ?>" <?php echo wplus_helper::show_value('enable_feedback_system', false) ? 'checked' : '' ?>>
    </div>
</div>

<div class="item p-18 br-bottom">
    <span class="title"><?php esc_html_e('تایید مدیر', 'woodmartplus') ?></span>
    <p class="des"><?php esc_html_e('بازخورد های ثبت شده نیاز به تایید دارند؟', 'woodmartplus'); ?></p>
    <div>
        <select class="js-example-basic-multiple" name="<?php echo wplus_helper::generate_option('[feedback_approval]'); ?>">
            <?php foreach (wplus_helper::get_admin_feedback_approval() as $key => $value): ?>
                <option value="<?php echo esc_attr($key) ?>" <?php selected($key, wplus_helper::show_value('feedback_approval', false)) ?>><?php echo esc_html($value); ?></option>
            <?php endforeach; ?>
        </select>
    </div>
</div>


<?php if (!wplus_helper::get_setting('enable_woo_wallet')): ?>
    <p class="dashboard-warning"><?php esc_html_e('برای استفاده از این قابلیت شما نیاز به فعال کردن کیف پول دارید', 'woodmartplus') ?></p>
<?php endif; ?>

<div class="item p-18 br-bottom <?php echo !wplus_helper::get_setting('enable_woo_wallet') ? 'dashboard-disable-section' : '' ?>">

    <span class="title"><?php esc_html_e('پس از ثبت بازخورد', 'woodmartplus'); ?></span>
    <p class="des"><?php esc_html_e('پس از ثبت باز خورد کیف پول شارژ شود؟', 'woodmartplus') ?></p>
    <div class="btn-select">
        <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[enable_feedback_charge_wallet]'); ?>" <?php echo wplus_helper::show_value('enable_feedback_charge_wallet', false) ? 'checked' : '' ?>>
    </div>
</div>

<div class="item br-bottom p-18 <?php echo !wplus_helper::get_setting('enable_woo_wallet') ? 'dashboard-disable-section' : '' ?>">

    <span class="title"><?php echo esc_html_e('قیمت شارژ', 'woodmartplus'); ?></span>
    <p class="des"><?php esc_html_e('پس از ثبت هر بازخورد کیف پول چه مقدار شارژ شود؟', 'woodmartplus'); ?></p>
    <div class="suggestion-inputs gray-inp">
        <input type="number" class="left-text" name="<?php echo wplus_helper::generate_option('[feedback_wallet_price]'); ?>" value="<?php wplus_helper::show_value('feedback_wallet_price'); ?>">
    </div>
</div>

<div class="item p-18 br-bottom">
    <span class="title"><?php esc_html_e('فعال کردن سیستم اطلاع رسانی برای ثبت بازخورد', 'woodmartplus'); ?></span>
    <p class="des"><?php esc_html_e('با فعال کردن این سیستم شما میتوانید از طریق پیامک و یا ایمیل اطلاع رسانی کنید') ?></p>
    <div class="btn-select">
        <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[enable_notif_feedback]'); ?>" <?php echo wplus_helper::show_value('enable_notif_feedback', false) ? 'checked' : '' ?> data-condition="notif_feedback_most_enabled">
    </div>
</div>

<div class="item br-bottom p-18 notif_feedback_most_enabled">

    <span class="title"><?php echo esc_html_e('تعداد ارسال پیامک', 'woodmartplus'); ?></span>
    <p class="des"><?php esc_html_e('چه تعداد پیام در صف ارسال پیامک قرار بگیرد؟ حداکثر 50', 'woodmartplus'); ?></p>
    <div class="suggestion-inputs gray-inp">
        <input type="number" class="left-text" max="50" name="<?php echo wplus_helper::generate_option('[feedback_number_message]'); ?>" value="<?php wplus_helper::show_value('feedback_number_message'); ?>" placeholder="20">
    </div>
</div>

<div class="item p-18 br-bottom notif_feedback_most_enabled">
    <span class="title"><?php esc_html_e('مرتب سازی بر اساس', 'woodmartplus') ?></span>
    <p class="des"><?php esc_html_e('مرتب سازی پیامک های در صف ارسال', 'woodmartplus'); ?></p>
    <div>
        <select class="js-example-basic-multiple" name="<?php echo wplus_helper::generate_option('[feedback_orderby_message]'); ?>">
            <option value="DESC" <?php selected('DESC', wplus_helper::show_value('feedback_orderby_message', false)) ?>><?php esc_html_e('نزولی') ?></option>
            <option value="ASC" <?php selected('ASC', wplus_helper::show_value('feedback_orderby_message', false)) ?>><?php esc_html_e('صعودی') ?></option>
        </select>
    </div>
</div>

<div class="item p-18 br-bottom notif_feedback_most_enabled">
    <span class="title"><?php esc_html_e('به چه روشی اطلاع رسانی شود؟', 'woodmartplus') ?></span>
    <p class="des"><?php esc_html_e('روش اطلاع رسانی را انتخاب کنید', 'woodmartplus'); ?></p>
    <div>
        <select class="js-example-basic-multiple" name="<?php echo wplus_helper::generate_option('[feedback_notif_provider]'); ?>">
            <?php foreach (wplus_helper::get_notif_provider_feedback_system() as $key => $value): ?>
                <option value="<?php echo esc_attr($key) ?>" <?php selected($key, wplus_helper::show_value('feedback_notif_provider', false)) ?>><?php echo esc_html($value); ?></option>
            <?php endforeach; ?>
        </select>
    </div>
</div>

<div class="item notif_feedback_most_enabled">
    <div class="manager-sms-wrapper">
        <div class="short-code br-bottom p-18">
            <div class="short-code-text">
                <span class="title"><?php esc_html_e('شورت کد های قابل استفاده','woodmartplus') ?></span>
                <p class="des"><?php esc_html_e('می توانید از این شورت کد ها در متن پیامک استفاده کنید','woodmartplus') ?></p>
            </div>
            <div class="short-code-detailes br-radius-8">
                <p>
                    جزییات سفارش: <br>
                    [billing_phone] = شماره تلفن مشتری  <br>
                    [billing_email] = ایمیل مشتری <br>
                    [billing_status] = وضعیت سفارش <br>
                    [billing_items] = محصولات سفارش <br>
                    [billing_all_items_qty] = محصولات سفارش بهمراه تعداد <br>
                    [billing_count_items] = تعداد محصولات سفارش 
                </p>
                <br>
                <p> 
                [billing_price] = مبلغ سفارش <br> 
                [billing_order_id] = شماره سفارش <br>
                    [billing_date] = تاریخ سفارش <br> 
                    [billing_customer_not] = توضیحات مشتری <br>
                    [billing_payment_method] = روش پرداخت <br> 
                    [billing_shipping_method] = روش ارسال</p>
                <br>
                <p>جزییات صورت حساب :<br>
                    [billing_first_name] = نام مشتری <br>
                    [billing_last_name] = نام خانوادگی مشتری <br>
                    [billing_company] = نام شرکت <br> 
                    [billing_country] = کشور <br>
                    [billing_state] = ایالت/استان <br>
                    [billing_city] = شهر <br>
                    [billing_address_1] = آدرس 1 <br>
                    [billing_address_2] = آدرس 2 <br>
                    [billing_postcode] = کد پستی</p>
                <br>
                <p>جزییات حمل و نقل :<br>
                    [shipping_first_name] = نام مشتری <br> 
                    [shipping_last_name] = نام خانوادگی مشتری <br>
                    [shipping_company] = نام شرکت <br>
                    [shipping_country] = کشور <br>
                    [shipping_state] = ایالت/استان <br>
                    [shipping_city] = شهر <br>
                    [shipping_address_1] = آدرس 1 <br>
                    [shipping_address_2] = آدرس 2 <br>
                    [shipping_postcode] = کد پستی</p>
                <br>
                <p>
                    [home_url] = آدرس وبسایت <br> 
                    [shop_url] = آدرس فروشگاه<br>
                    [account_url] =  صفحه ورود و ثبت نام <br>
                </p>
            </div>
        </div>

         <br>
                
        <?php $feed_back = wplus_helper::get_setting('feed_back', []); ?>
        <div class="add-suggestions open_acard" style="margin-top:20px;">
            <div class="suggestion-title">
                <span class="suggestion-menu">
                    <p><?php esc_html_e('متن پیامک ثبت بازخورد', 'woodmartplus'); ?></p>
                </span>
                <span class="arrow-icon"><img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/arrow-down2.svg" alt=""></span>
            </div>
            <div class="suggestion-content">
                <div class="suggestion-inputs gray-inp">
                    <!-- Pattern Input -->
                    <div class="suggestion-inputs gray-inp" style="margin-bottom:.8rem;">
                        <input type="text" name="<?php echo wplus_helper::generate_option('[feed_back][pattern]'); ?>" placeholder="<?php esc_html_e('پترن پیامک را وارد کنید', 'woodmartplus'); ?>" value="<?php echo isset($feed_back['pattern']) && !empty($feed_back['pattern']) ? esc_html($feed_back['pattern']) : '' ?>">
                    </div>
                    <!-- Variables Repeater -->
                    <div class="repeater-container">
                        <div data-repeater-list="<?php echo wplus_helper::generate_option('[feed_back][variables]'); ?>">
                            <?php if (isset($feed_back['variables']) && !empty($feed_back['variables'])) : ?>
                                <?php foreach ($feed_back['variables'] as $key => $value) : ?>

                                    <div data-repeater-item>
                                        <div class="send-time">
                                            <div>
                                                <input type="text" name="variable" placeholder="<?php esc_html_e('متغیر','woodmartplus') ?>" value="<?php echo isset($value['variable'])  ? esc_html($value['variable']) : '' ?>">
                                                <input type="text" name="shortcode" placeholder="<?php esc_html_e('شورتکد','woodmartplus') ?>" value="<?php echo isset($value['shortcode']) && !empty($value['shortcode']) ? esc_html($value['shortcode']) : '' ?>">
                                                <a data-repeater-delete class="delete-btn">
                                                    <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php else : ?>
                                <div data-repeater-item>
                                    <div class="send-time">
                                        <div>
                                            <input type="text" name="variable" placeholder="<?php esc_html_e('متغیر','woodmartplus') ?>">
                                            <input type="text" name="shortcode" placeholder="<?php esc_html_e('شورتکد','woodmartplus') ?>">
                                            <a data-repeater-delete class="delete-btn">
                                                <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="add-time">
                            <button data-repeater-create type="button">
                                <!-- <img src="path/to/plus.svg" alt="add"> -->
                                <p><?php esc_html_e('افزودن متغیر جدید', 'woodmartplus'); ?></p>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="awaiting-payment-immediately-cust br-radius-8 m-18">
            <div class="awaiting-payment-immediately-text-cust"> <?php esc_html_e('موضوع ایمیل', 'woodmartplus') ?> </div>
            <div class="awaiting-payment-immediately-inp-cust">
                <input type="text" name="<?php echo wplus_helper::generate_option('[notif_feedback_email_subject]'); ?>" placeholder="<?php esc_html_e('موضوع ایمیل ثبت باز خورد', 'woodmartplus') ?>" value="<?php wplus_helper::show_value('notif_feedback_email_subject') ?>">
            </div>
        </div>
        <div class="awaiting-payment-immediately-cust br-radius-8 m-18">
            <div class="awaiting-payment-immediately-text-cust"> <?php esc_html_e('متن ایمیل', 'woodmartplus') ?> </div>
            <div class="awaiting-payment-immediately-inp-cust">
                <textarea placeholder="<?php esc_html_e('متن ایمیل را وارد کنید', 'woodmartplus'); ?>" name="<?php echo wplus_helper::generate_option('[notif_feedback_message_email]'); ?>"><?php wplus_helper::show_value('notif_feedback_message_email') ?></textarea>
            </div>
        </div>

    </div>
</div>