<?php
$tab_detials = class_exists('import_myaccount_page') ?  import_myaccount_page::load_tab() : [];
?>
<div class="item p-18 br-bottom">
   <span class="title"><?php esc_html_e('درون ریزی برخی صفحات داشبورد', 'woodmartplus'); ?></span>
   <p class="des"><?php esc_html_e('برخی صفحات اماده که در المنتور طراحی شده اند درون ریزی می شود', 'woodmartplus') ?></p>

   <div class="importer-container">
      <div class="importer-tabs">

         <ul class="importer-tab-nav">
            <?php $i = 0;
            foreach ($tab_detials as $tab => $value): ?>
               <li class="<?php echo $i == 0 ? 'active' : '' ?>" data-tab="<?php echo $tab; ?>"><?php echo $value['tab_name']; ?></li>
            <?php $i++;
            endforeach; ?>
         </ul>

         <div class="importer-tab-content">
            <?php $b = 0;
            foreach ($tab_detials as $tab => $value):  ?>
               <div class="tab-pane <?php echo $b == 0 ? 'active' : '' ?>" id="<?php echo $tab; ?>-tab">
                  <div class="designs-grid">
                     <?php foreach ($value['demos'] as $demo_name => $value_name): ?>
                        <div class="design-item">
                           <div class="design-preview">
                              <img src="<?php echo esc_url($value_name['image']); ?>" alt="<?php echo esc_html($value_name['name']); ?>">
                              <div class="design-overlay">
                                 <button type="button" class="import-btn-account" data-fname="<?php echo esc_html($tab); ?>" data-design="<?php echo esc_html($demo_name); ?>" data-slider_image="<?php echo isset( $value_name['image_slider'] ) ? implode(',',$value_name['image_slider']): '' ?>"><?php esc_html_e('درون‌ریزی', 'woodmartplus'); ?></button>
                              </div>
                           </div>
                           <h4 class="design-title"><?php echo esc_html($value_name['name']); ?></h4>
                        </div>
                     <?php endforeach; ?>
                  </div>
               </div>
            <?php $b++;
            endforeach; ?>

         </div>
      </div>
   </div>

   <div class="import-status">
      <div class="import-progress">
         <div class="progress-bar"></div>
      </div>
      <div class="import-message"></div>
   </div>

   <div class="btn-select show_dashboard_builder" style="display: none;">
      <a href="<?php echo admin_url('edit.php?post_type=dashboard_builder') ?>" class="chang-btn blue-btn-bg" name="import_myaccount" value="import"><?php esc_html_e('مشاهده صفحه ساخت حساب کاربری', 'woodmartplus'); ?></a>
   </div>
</div>



<script>
   jQuery(document).ready(function($) {
      $('.importer-tab-nav li').on('click', function() {
         var tabId = $(this).data('tab');

         $('.importer-tab-nav li').removeClass('active');
         $(this).addClass('active');

         $('.tab-pane').removeClass('active');
         $('#' + tabId + '-tab').addClass('active');
      });
   });
</script>