<?php 
$sms_otp = wplus_helper::get_setting('smsotp');

?>
<?php if (!wplus_helper::check_panel_is_active()): ?>
   <div class="item p-18 br-bottom">
      <span class="title warning-title"><?php esc_html_e('توجه کنید ، ثبت نام و ورود از طریق موبایل امکان پذیر نیست ، برای فعال شدن این موضوع از گزینه اپراتور های اس ام اس ، اطلاعات اپراتور مورد نظر خود را با دقت قرار دهید', 'woodmartplus') ?></span>
   </div>
<?php endif; ?>
<div class="item p-18 br-bottom">
   <span class="title"><?php esc_html_e('فعال کردن ثبت نام و ورود', 'woodmartplus'); ?></span>
   <p class="des"></p>
   <div class="btn-select">
      <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[setting_loginregister_enable]'); ?>" <?php echo wplus_helper::show_value('setting_loginregister_enable', false) ? 'checked' : '' ?>>
   </div>
</div>
<?php if (wplus_helper::get_setting('setting_enable_myaccount_elementor')): ?>
<div class="item p-18 br-bottom">
   <span class="title"><?php esc_html_e('فعال کردن ثبت نام و ورود با المنتور', 'woodmartplus'); ?></span>
   <p class="des"><?php esc_html_e('شما می توانید صفحه ثبت نام و ورود خود را در المنتور طراحی کنید', 'woodmartplus') ?></p>
   <div class="btn-select">
      <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[login_register_elementor]'); ?>" <?php echo wplus_helper::show_value('login_register_elementor', false) ? 'checked' : '' ?>>
   </div>
</div>
<?php endif; ?>


<?php $logo_login_register = wplus_helper::get_setting('logo_login_register'); ?>
<div class="item p-18">
   <span class="title"><?php esc_html_e('لوگوی ثبت نام و ورود', 'woodmartplus'); ?></span>
   <p class="des"><?php esc_html_e('آپلود لوگوی ثبت نام و ورود', 'woodmartplus'); ?></p>
   <div class="<?php echo isset($logo_login_register) && !empty($logo_login_register) ? 'upload-loding' : ''  ?> logo_login_register">
      <?php if (isset($logo_login_register) && !empty($logo_login_register)): ?>
         <?php $img_logo_lr = wp_get_attachment_image_src($logo_login_register, 'medium'); ?>
         <div class="upload-loding-img upload_image">
            <img class="img-responsive" src="<?php echo isset($img_logo_lr[0]) ? $img_logo_lr[0] : '' ?>" alt="logo_login_register">
         </div>
         <div class="upload-loding-btns">
            <span class="blue-btn upload-btn upload-image-button"><?php esc_html_e('ویرایش', 'woodmartplus'); ?></span>
            <span class="delete-btn remove-image-button">
               <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="trash">
            </span>
            <input type="hidden" name="<?php echo wplus_helper::generate_option('[logo_login_register]'); ?>" class="upload_image_id" value="<?php echo $logo_login_register ?>" />
         </div>
      <?php else: ?>
         <div class="upload_image">
         </div>
         <div class="upload-loding-btns">
            <span class="blue-btn upload-btn upload-image-button"><?php esc_html_e('آپلود', 'woodmartplus'); ?></span>
            <span class="delete-btn remove-image-button" style="display: none;">
               <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="trash">
            </span>
            <input type="hidden" name="<?php echo wplus_helper::generate_option('[logo_login_register]'); ?>" class="upload_image_id" value="" />
         </div>
      <?php endif; ?>
   </div>
</div>

<div class="item p-18 br-bottom">
   <span class="title"><?php esc_html_e('رنگ پس زمینه ورود و ثبت نام', 'woodmartplus') ?></span>
   <p class="des"><?php esc_html_e('انتخاب رنگ پس زمینه', 'woodmartplus') ?></p>
   <div class="chose-color">
      <div class="color-palet"><input class="color_picke" type="text" name="<?php echo wplus_helper::generate_option('[color_bg_login_register]'); ?>" value="<?php wplus_helper::show_value('color_bg_login_register'); ?>"></div>
      <div class="color-icon">
         <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/brush.svg" alt="brush">
      </div>
   </div>
   <p class="des"><?php esc_html_e('انتخاب رنگ دوم پس زمینه', 'woodmartplus') ?></p>
   <div class="chose-color">
      <div class="color-palet"><input class="color_picke" type="text" name="<?php echo wplus_helper::generate_option('[color_two_bg_login_register]'); ?>" value="<?php wplus_helper::show_value('color_two_bg_login_register'); ?>"></div>
      <div class="color-icon">
         <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/brush.svg" alt="brush">
      </div>
   </div>
</div>

<div class="item p-18 br-bottom">
   <span class="title"><?php esc_html_e('انتخاب برگه قوانین و مقرارت', 'woodmartplus') ?></span>
   <p class="des"><?php esc_html_e('برگه قوانین و مقرارت حریم خصوصی', 'woodmartplus') ?></p>
   <div class="dropdown_select">
      <select name="<?php echo wplus_helper::generate_option('[terms_and_conditions]'); ?>" class="dropdown">
         <option value="default"><?php esc_html_e('انتخاب گزینه', 'woodmartplus'); ?></option>
         <?php foreach (wplus_helper::get_page_register() as $key => $page): ?>
            <option value="<?php echo esc_attr($key) ?>" <?php selected($key, wplus_helper::show_value('terms_and_conditions', false)) ?>><?php echo esc_html($page) ?></option>
         <?php endforeach; ?>
      </select>
   </div>
</div>

<div class="item br-bottom p-18">
   <span class="title"><?php esc_html_e('ریدارکت بعد از ورود', 'woodmartplus'); ?></span>
   <p class="des"><?php esc_html_e('پس از ثبت نام و ورود کاربر به چه صفحه ای ریدایرکت شود ؟ پیشفرض به حساب کاربری', 'woodmartplus'); ?></p>
   <div class="suggestion-inputs gray-inp">
      <input type="text" class="left-text" name="<?php echo wplus_helper::generate_option('[redirect_after_login]'); ?>" value="<?php wplus_helper::show_value('redirect_after_login'); ?>" placeholder="<?php echo home_url(); ?>">
   </div>
</div>

<div class="item p-18 br-bottom">
   <span class="title"><?php esc_html_e('حالت ثبت نام و ورود', 'woodmartplus') ?></span>
   <p class="des"><?php esc_html_e('نوع ثبت نام و ورود را انتخاب کنید', 'woodmartplus') ?></p>
   <div class="dropdown_select">
      <select name="<?php echo wplus_helper::generate_option('[register_login_type]'); ?>" class="dropdown select_layout">
         <option disabled selected><?php esc_html_e('لطفا یک گزینه را انتخاب کنید.', 'woodmartplus'); ?></option>
         <option value="layout-5" <?php selected('layout-5', wplus_helper::show_value('register_login_type', false)); ?>><?php esc_html_e('ثبت نام و ورود پیامکی', 'woodmartplus'); ?></option>
         <option value="layout-4" <?php selected('layout-4', wplus_helper::show_value('register_login_type', false)); ?>><?php esc_html_e('پیشفرض', 'woodmartplus'); ?></option>
      </select>
   </div>
</div>

<div class="item p-18 br-bottom enable_phone_login" style="display: none;">
   <span class="title"><?php esc_html_e('فعال شدن ثبت نام ورود با موبایل', 'woodmartplus'); ?></span>
   <p class="des"><?php esc_html_e('برای فعال شدن ثبت نام و ورود با شماره همراه ، گزینه را فعال کنید', 'woodmartplus') ?></p>
   <div class="btn-select">
      <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[enable_phone_login_register]'); ?>" <?php echo wplus_helper::show_value('enable_phone_login_register', false) ? 'checked' : '' ?> data-condition="phone_login_register_condition">
   </div>
</div>

<div class="item phone_login_register_condition">
   <div class="manager-sms-wrapper">
      <div class="br-bottom">
         <div class="sms-sent-post m-t-18" style="margin-bottom: 15px;">
            <div class="short-code-text">
               <span class="title"><?php esc_html_e('شورتکد ها', 'woodmartplus'); ?></span>
               <p class="des"><?php esc_html_e('شورتکد احراز هویت', 'woodmartplus'); ?></p>
            </div>
            <div class="sms-sent-post-detailes br-radius-8">
               <p><?php esc_html_e('کد احراز هویت = [OTP]', 'woodmartplus'); ?></p>
            </div>
         </div>
      </div>
      <div class="add-suggestions open_acard opened" style="margin-top:20px;">
         <div class="suggestion-title">
            <span class="suggestion-menu">
               <p><?php esc_html_e('قرار دادن پترن(الگو) و متغییر های آن (ارسال پیامک احراز هویت)', 'woodmartplus'); ?></p>
            </span>
            <span class="arrow-icon"><img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/arrow-down2.svg" alt=""></span>
         </div>
         <div class="suggestion-content">
            <div class="suggestion-inputs gray-inp">
               <!-- Pattern Input -->
               <div class="suggestion-inputs gray-inp" style="margin-bottom:.8rem;">
                  <input type="text" name="<?php echo wplus_helper::generate_option('[smsotp][pattern]'); ?>" placeholder="<?php esc_html_e('پترن پیامک را وارد کنید', 'woodmartplus'); ?>" value="<?php echo isset($sms_otp['pattern']) && !empty($sms_otp['pattern']) ? esc_html($sms_otp['pattern']) : '' ?>">
               </div>
               <!-- Variables Repeater -->
               <div class="repeater-container">
                  <div data-repeater-list="<?php echo wplus_helper::generate_option('[smsotp][variables]'); ?>">
                     <?php if (isset($sms_otp['variables']) && !empty($sms_otp['variables'])) : ?>
                        <?php foreach ($sms_otp['variables'] as $key => $value) : ?>

                           <div data-repeater-item>
                              <div class="send-time">
                                 <div>
                                    <input type="text" name="variable" placeholder="<?php esc_html_e('متغیر', 'woodmartplus'); ?>" value="<?php echo isset($value['variable'])  ? esc_html($value['variable']) : '' ?>">
                                    <input type="text" name="shortcode" placeholder="<?php esc_html_e('شورتکد', 'woodmartplus'); ?>" value="<?php echo isset($value['shortcode']) && !empty($value['shortcode']) ? esc_html($value['shortcode']) : '' ?>">
                                    <a data-repeater-delete class="delete-btn">
                                       <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                                    </a>
                                 </div>
                              </div>
                           </div>
                        <?php endforeach; ?>
                     <?php else : ?>
                        <div data-repeater-item>
                           <div class="send-time">
                              <div>
                                 <input type="text" name="variable" placeholder="<?php esc_html_e('متغیر', 'woodmartplus'); ?>">
                                 <input type="text" name="shortcode" placeholder="<?php esc_html_e('شورتکد', 'woodmartplus'); ?>">
                                 <a data-repeater-delete class="delete-btn">
                                    <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                                 </a>
                              </div>
                           </div>
                        </div>
                     <?php endif; ?>
                  </div>
                  <div class="add-time">
                     <button data-repeater-create type="button">
                        <p><?php esc_html_e('افزودن متغیر جدید', 'woodmartplus'); ?></p>
                     </button>
                  </div>
               </div>
            </div>
         </div>
      </div>

   </div>
</div>

<div class="item p-18 br-bottom enable_email_login" style="display: none;">
   <span class="title"><?php esc_html_e('فعال شدن ثبت نام و ورود با ایمیل', 'woodmartplus'); ?></span>
   <p class="des"><?php esc_html_e('برای فعال شدن ثبت نام و ورود با ایمیل ، گزینه را فعال کنید', 'woodmartplus') ?></p>
   <div class="btn-select">
      <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[enable_email_login_register]'); ?>" <?php echo wplus_helper::show_value('enable_email_login_register', false) ? 'checked' : '' ?> data-condition="email_login_register_condition">
   </div>
</div>

<div class="email_login_register_condition">
   <div class="item br-bottom p-18">
      <span class="title"><?php esc_html_e('ارسال ایمیل از آدرس', 'woodmartplus') ?></span>
      <p class="des"><?php esc_html_e('ایمیل های ارسالی از چه آدرسی انجام شود ؟ تنظیمات smpt هاست خود را بررسی کنید', 'woodmartplus'); ?></p>
      <div class="suggestion-inputs gray-inp">
         <input type="text" class="left-text" name="<?php echo wplus_helper::generate_option('[email_send_from]'); ?>" value="<?php echo wplus_helper::show_value('email_send_from', false) ? wplus_helper::show_value('email_send_from') : '' ?>">
      </div>
   </div>

   <div class="item br-bottom p-18">
      <span class="title"><?php esc_html_e('نام ارسال کننده ایمیل', 'woodmartplus') ?></span>
      <p class="des"><?php esc_html_e('نام ارسال کننده ایمیل را وارد کنید', 'woodmartplus'); ?></p>
      <div class="suggestion-inputs gray-inp">
         <input type="text" class="left-text" name="<?php echo wplus_helper::generate_option('[email_send_from_name]'); ?>" value="<?php echo wplus_helper::show_value('email_send_from_name', false) ? wplus_helper::show_value('email_send_from_name') : '' ?>">
      </div>
   </div>

   <div class="item br-bottom p-18">
      <span class="title"><?php esc_html_e('موضوع ایمیل', 'woodmartplus') ?></span>
      <p class="des"><?php esc_html_e('موضوع ایمیل را وارد کنید', 'woodmartplus'); ?></p>
      <div class="suggestion-inputs gray-inp">
         <input type="text" class="left-text" name="<?php echo wplus_helper::generate_option('[email_send_subject]'); ?>" value="<?php echo wplus_helper::show_value('email_send_subject', false) ? wplus_helper::show_value('email_send_subject') : __('احراز هویت','woodmartplus'); ?>">
      </div>
   </div>
   <div class="item br-bottom p-18">
      <span class="title"><?php esc_html_e('متن کد احراز هویت برای ایمیل ، از [otp] در متن استفاده کنید', 'woodmartplus') ?></span>
      <p class="des"><?php esc_html_e('برای مثال ،  کد احراز هویت شما [otp] میباشد :', 'woodmartplus'); ?></p>
      <div class="suggestion-inputs gray-inp">
         <textarea name="<?php echo wplus_helper::generate_option('[text_send_otp_email]'); ?>"><?php wplus_helper::show_value('text_send_otp_email') ?? ''; ?></textarea>
      </div>
   </div>
</div>

<div class="item br-bottom p-18 enable_pattern_section">
   <span class="title"><?php esc_html_e('متغییر های ارسال پیامک به همراه ایمیل', 'woodmartplus'); ?></span>
   <p class="des"><?php esc_html_e('متغییر های خود را تنظیم کنید', 'woodmartplus'); ?></p>
   <div class="progress-wrapper br-radius-8 m-t-18">
      <div class="progress-content">
         <div class="progress-bar-left">
            <p><?php esc_html_e('مدت زمان انتظار ارسال مجدد', 'woodmartplus') ?></p>
            <div class="inp-rang p-top-18">
               <input type="range" class="rang" min="1" max="120" value="<?php echo wplus_helper::show_value('wating_resend', false) ? wplus_helper::show_value('wating_resend') :  50 ?>" name="<?php echo wplus_helper::generate_option('[wating_resend]'); ?>">
               <div class="br-radius-8 rang-number d-center">
                  <span class="num">1200</span><span class="text-num"><?php esc_html_e('ثانیه', 'woodmartplus'); ?></span>
               </div>
            </div>
         </div>
         <div class="progress-bar-right">
            <p><?php esc_html_e('مدت زمان ممنوعیت', 'woodmartplus') ?></p>
            <div class="inp-rang p-top-18">
               <input type="range" class="rang" min="1" max="700" value="<?php echo wplus_helper::show_value('ban_time', false) ? wplus_helper::show_value('ban_time') :  120 ?>" name="<?php echo wplus_helper::generate_option('[ban_time]'); ?>">
               <div class="br-radius-8 rang-number d-center">
                  <span class="num">1200</span><span class="text-num"><?php esc_html_e('ثانیه', 'woodmartplus'); ?></span>
               </div>
            </div>
         </div>
      </div>
      <div class="progress-content">
         <div class="progress-bar-left">
            <p><?php esc_html_e('تعداد ارسال مجدد کد احراز هویت', 'woodmartplus') ?></p>
            <div class="inp-rang p-top-18">
               <input type="range" class="rang" min="1" max="100" value="<?php echo wplus_helper::show_value('otp_resend', false) ? wplus_helper::show_value('otp_resend') :  50 ?>" name="<?php echo wplus_helper::generate_option('[otp_resend]'); ?>">
               <div class="br-radius-8 rang-number d-center">
                  <span class="num">1200</span><span class="text-num"><?php esc_html_e('مرتبه', 'woodmartplus'); ?></span>
               </div>
            </div>
         </div>
         <div class="progress-bar-right">
            <p><?php esc_html_e('مدت زمان اعتبار کد احراز هویت', 'woodmartplus') ?></p>
            <div class="inp-rang p-top-18">
               <input type="range" class="rang" min="1" max="120" value="<?php echo wplus_helper::show_value('expire_otp', false) ? wplus_helper::show_value('expire_otp') :  60 ?>" name="<?php echo wplus_helper::generate_option('[expire_otp]'); ?>">
               <div class="br-radius-8 rang-number d-center">
                  <span class="num">120</span><span class="text-num"><?php esc_html_e('ثانیه', 'woodmartplus'); ?></span>
               </div>
            </div>
         </div>
      </div>
      <div class="progress-content">
         <div class="progress-bar-left">
            <p><?php esc_html_e('تعداد خطاهای اشتباه کد احراز هویت', 'woodmartplus') ?></p>
            <div class="inp-rang p-top-18">
               <input type="range" class="rang" min="1" max="6" value="<?php echo wplus_helper::show_value('incorretct_otp', false) ? wplus_helper::show_value('incorretct_otp') :  4 ?>" name="<?php echo wplus_helper::generate_option('[incorretct_otp]'); ?>">
               <div class="br-radius-8 rang-number d-center">
                  <span class="num">1200</span><span class="text-num"><?php esc_html_e('مرتبه', 'woodmartplus'); ?></span>
               </div>
            </div>
         </div>
         <div class="progress-bar-right">
            <p><?php esc_html_e('تعداد ارقام کد احراز هویت', 'woodmartplus'); ?></p>
            <div class="inp-rang p-top-18">
               <input type="range" class="rang" min="1" max="6" value="<?php echo wplus_helper::show_value('number_otp', false) ? wplus_helper::show_value('number_otp') :  4 ?>" name="<?php echo wplus_helper::generate_option('[number_otp]'); ?>">
               <div class="br-radius-8 rang-number d-center">
                  <span class="num">1200</span><span class="text-num"><?php esc_html_e('تعداد', 'woodmartplus'); ?></span>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>

<div class="item p-18 br-bottom enable_quick_register" style="display: none;">
   <span class="title"><?php esc_html_e('ثبت نام سریع با موبایل', 'woodmartplus'); ?></span>
   <p class="des"><?php esc_html_e('با فعال کردن این گزینه ، فرم دریافت اطلاعات برای ثبت نام حذف میشود', 'woodmartplus') ?></p>
   <div class="btn-select">
      <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[enable_quick_register]'); ?>" <?php echo wplus_helper::show_value('enable_quick_register', false) ? 'checked' : '' ?> data-condition="quick_register_condition">
   </div>
</div>

<div class="item p-18 br-bottom enable_quick_register" style="display: none;">
   <span class="title"><?php esc_html_e('ورود بدون رمزعبور', 'woodmartplus'); ?></span>
   <p class="des"><?php esc_html_e('با فعال کردن این گزینه قسمت دریافت رمزعبور حذف و با OTP (احراز هویت) ورود انجام میشود (قسمت رمزعبور هم برای ایمیل و هم برای موبایل غیرفعال میشود)', 'woodmartplus') ?></p>
   <div class="btn-select">
      <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[enable_login_whitoute_password]'); ?>" <?php echo wplus_helper::show_value('enable_login_whitoute_password', false) ? 'checked' : '' ?> >
   </div>
</div>


<div class="item p-18 br-bottom quick_register_condition">
   <span class="title"><?php esc_html_e('ساخت نام کاربری', 'woodmartplus') ?></span>
   <p class="des"><?php esc_html_e('زمان ثبت نام سریع ، نام کاربری به چه صورت برای ایجاد شود؟', 'woodmartplus') ?></p>
   <div class="dropdown_select">
      <select name="<?php echo wplus_helper::generate_option('[created_user_name_quick_register]'); ?>" class="dropdown">
         <option disabled selected><?php esc_html_e('لطفا یک گزینه را انتخاب کنید.', 'woodmartplus'); ?></option>
         <option value="random" <?php selected('random', wplus_helper::show_value('created_user_name_quick_register', false)); ?>><?php esc_html_e('به صورت رندوم ایجاد شود', 'woodmartplus'); ?></option>
         <option value="mobile" <?php selected('mobile', wplus_helper::show_value('created_user_name_quick_register', false)); ?>><?php esc_html_e('شماره موبایل همان نام کاربری باشد', 'woodmartplus'); ?></option>
      </select>
   </div>
</div>

<div class="item p-18 br-bottom">
   <span class="title"><?php esc_html_e('دریافت تاریخ تولد', 'woodmartplus'); ?></span>
   <p class="des"><?php esc_html_e('زمان ثبت نام از کاربر تاریخ تولد دریافت شود ؟', 'woodmartplus') ?></p>
   <div class="btn-select">
      <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[enable_field_birthday]'); ?>" <?php echo wplus_helper::show_value('enable_field_birthday', false) ? 'checked' : '' ?>>
   </div>
</div>

<div class="item p-18 br-bottom enable_quick_register" style="display: none;">
   <span class="title"><?php esc_html_e('جایگزین ثبت نام ورود وودمارت', 'woodmartplus'); ?></span>
   <p class="des"><?php esc_html_e('با فعال کردن این گزینه ، حالت ثبت نام و ورود هوشمند جایگزین ثبت نام وورود پیش فرض وودمارت میشود', 'woodmartplus') ?></p>
   <div class="btn-select">
      <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[enable_login_register_replaced]'); ?>" <?php echo wplus_helper::show_value('enable_login_register_replaced',false) ? 'checked' : '' ?>>
   </div>
</div>




