<?php
defined('ABSPATH') || exit;

$date_format = get_option('date_format');
$time_format = get_option('time_format');

$slug = get_post_meta($ticket->ID, 'wplus_ticket_departeman', true);
if ('departeman_order' === $slug) {
   $departeman = $object->get_name_departeman_by_slug($slug);
} else {
   $departeman = $object->get_name_departeman_by_id($slug);
}

$status = get_post_meta($ticket->ID, 'wplus_ticket_status', true);
$nameStatus = isset( $object->generate_ticket_status()[$status]['output'] ) ? $object->generate_ticket_status()[$status]['output'] : '';
$class_name = $object->get_class_name( $status );

wp_enqueue_script('aramis-media-core');
wp_enqueue_media();

?>
<div class="white_card--border_row edit-account">
   <div class="item">
      <div class="gap-x">
         <a href="<?php echo esc_url(wc_get_endpoint_url('tickets')); ?>" class="btn link">
            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none">
               <path d="M5.25005 2.38L9.05338 6.18333C9.50255 6.6325 9.50255 7.36749 9.05338 7.81666L5.25005 11.62" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
            </svg>
            <p><?php esc_html_e('بازگشت', 'woodmartplus'); ?></p>
         </a>
      </div>
   </div>
   <div class="item gap-y-2">
      <div class="ticket_chat__header">
         <div class="ticket_chat__items">
            <div class="ticket_chat__item">
               <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none" class="text_gray">
                  <path d="M2 3h12M2 6h8M2 9h10M2 12h6" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
               </svg>
               <p><span class="text_gray"><?php esc_html_e('موضوع', 'woodmartplus') ?>: </span> <?php echo esc_html($ticket->post_title); ?> </p>
            </div>
            <div class="vertical_seperator"></div>
            <div class="ticket_chat__item">
               <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none" class="text_gray">
                  <path d="M8 8c1.657 0 3-1.343 3-3S9.657 2 8 2 5 3.343 5 5s1.343 3 3 3z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                  <path d="M2 14c0-2.5 2.5-4 6-4s6 1.5 6 4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                  <path d="M11 5c1.657 0 3-1.343 3-3s-1.343-2-3-2" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                  <path d="M13 8c0 1.1-.9 2-2 2s-2-.9-2-2" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
               </svg>
               <p><span class="text_gray"><?php esc_html_e('دپارتمان', 'woodmartplus') ?>: </span><?php echo esc_html($departeman); ?></p>
            </div>
            <div class="vertical_seperator"></div>
            <div class="ticket_chat__item">
               <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none" class="text_gray">
                  <path d="M4 2v12M12 2v12M2 6h12M2 10h12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
               </svg>
               <p><span class="text_gray"><?php esc_html_e('وضعیت تیکت', 'woodmartplus'); ?>:</span><span class="badge_ticket <?php echo esc_html($class_name); ?>"><?php echo $nameStatus; ?></span> </p>
            </div>
            <div class="vertical_seperator"></div>
            <div class="ticket_chat__item">
               <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none" class="text_gray">
                  <path d="M4 2v12M12 2v12M2 6h12M2 10h12" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
               </svg>
               <p><span class="text_gray"><?php esc_html_e('شناسه تیکت', 'woodmartplus'); ?>:</span> <?php echo esc_html($ticket->ID) ?> </p>
            </div>
         </div>
         <div class="ticket_chat__items">
            <div class="ticket_chat__item">
               <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none" class="text_gray">
                  <rect x="2" y="3" width="12" height="11" rx="2" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
                  <path d="M2 7h12M6 1v4M10 1v4" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
               </svg>
               <p><span class="text_gray"><?php esc_html_e('تاریخ ایجاد', 'woodmartplus'); ?>:</span> </span> <?php echo esc_html(wplus_helper::date_to_garegorian(strtotime($ticket->post_date))); ?> </p>
            </div>
            <div class="vertical_seperator"></div>
            <div class="ticket_chat__item">
               <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none" class="text_gray">
                  <path d="M13.5 2.5A6.5 6.5 0 0 0 1.5 9h3l-2.5 2.5L0 9h3A8 8 0 1 1 16 8" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
               </svg>
               <p><span class="text_gray"><?php esc_html_e('آخرین به روز رسانی', 'woodmartplus'); ?>: </span><?php echo esc_html(wplus_helper::date_to_garegorian(strtotime($ticket->post_modified))); ?></p>
            </div>
         </div>
      </div>
      <div class="ticket_seperator">
         <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none" class="text_danger">
            <circle cx="8" cy="8" r="7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
            <path d="M8 4v8M5 9l3 3 3-3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
         </svg>
         <hr />
      </div>
      <div class="ticket_chatbox__container">
         <?php foreach ($messages as $key => $message):  ?>
            <?php if ($message->woodmartplus_is_customer):
               $full_name = isset($first_name) && !empty($first_name) ? $first_name . ' ' . $last_name : __('مشتری', 'woodmartplus');
               $avatar = get_user_meta($message->post_author, '_acount_image', true);
               $photos = get_posts([
                  'post_type' => 'attachment',
                  'post_parent' => $message->ID,
                  'fields' => 'ids',
                  'posts_per_page' => -1,
               ]);

            ?>
               <div class="ticket_chatbox send">
                  <div class="chatbox_avatar">
                     <?php if ($avatar): ?>
                        <img src="<?php echo  esc_url(wp_get_attachment_url($avatar)); ?>" alt="user avatar" />
                     <?php else: ?>
                        <img src="<?php echo WOODPLUS_ASSET . 'img/user.svg' ?>" alt="user avatar" />
                     <?php endif; ?>
                  </div>
                  <div class="chat_container">
                     <div class="chat_message">
                        <p>
                           <?php echo esc_html($message->post_content); ?>
                        </p>
                        <?php if ($photos): ?>
                           <div class="chat_attach__container">
                              <div class="chat_attach__item">
                                 <?php foreach ($photos as $photo): ?>
                                    <a href="<?php echo esc_url(wp_get_attachment_url($photo)); ?>" target="_blank">
                                       <div class="photo">
                                          <img src="<?php echo esc_url(wp_get_attachment_url($photo)); ?>" alt="product">
                                       </div>
                                    </a>
                                 <?php endforeach; ?>
                              </div>
                           </div>
                        <?php endif; ?>
                     </div>
                     <div class="chat_end">
                        <p class="chat_end__username"><?php echo esc_html($full_name); ?></p>
                        <div class="vertical_line"></div>
                        <p class="chat_end__date">
                           <?php echo wplus_helper::date_to_garegorian(strtotime($message->post_date), $date_format . " " . $time_format); ?>
                        </p>
                     </div>
                  </div>
               </div>
            <?php else:
               $full_name = isset($first_name) && !empty($first_name) ? $first_name . ' ' . $last_name : __('مشتری', 'woodmartplus');
               $photos = get_post_meta($message->ID, 'wplus_ticket_manager_uploader', true);
               get_posts([
                  'post_type' => 'attachment',
                  'post_parent' => $message->ID,
               ]);
            ?>
               <div class="ticket_chatbox receive">
                  <div class="chatbox_avatar">
                     <img src="<?php echo WOODPLUS_ASSET . 'img/user.svg' ?>" alt="user avatar" />
                  </div>
                  <div class="chat_container">
                     <div class="chat_message">
                        <p>
                           <?php echo esc_html($message->post_content); ?>
                        </p>
                        <?php if ($photos): ?>
                           <div class="chat_attach__container">
                              <div class="chat_attach__item">
                                 <?php foreach ($photos as $photo): ?>
                                    <a href="<?php echo esc_url(wp_get_attachment_url($photo)); ?>" target="_blank">
                                       <div class="photo">
                                          <img src="<?php echo esc_url(wp_get_attachment_url($photo)); ?>" alt="product">
                                       </div>
                                    </a>
                                 <?php endforeach; ?>
                              </div>
                           </div>
                        <?php endif; ?>
                     </div>
                     <div class="chat_end">
                        <p class="chat_end__username"><?php $full_name ?></p>
                        <div class="vertical_line"></div>
                        <p class="chat_end__date">
                           <?php echo wplus_helper::date_to_garegorian(strtotime($message->post_date), $date_format . " " . $time_format); ?>
                        </p>
                     </div>
                  </div>
               </div>
            <?php endif; ?>
         <?php endforeach; ?>
      </div>
      <div class="ticket_seperator">
         <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none" class="text_danger">
            <circle cx="8" cy="8" r="7" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
            <path d="M8 4v8M5 9l3 3 3-3" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
         </svg>
         <hr />
      </div>
      <?php if ($status !== 'wplus_ticket_clossed') : ?>
         <div class="gap-y-3">
            <p class="text_black"><?php esc_html_e('پاسخ به تیکت', 'woodmartplus'); ?></p>
            <form action="" class="add_ticket__form" method="POST" enctype="multipart/form-data">
               <div class="solid_input oneline">
                  <label for="txtTicketDescription"><?php esc_html_e('توضیحات', 'woodmartplus'); ?><span class="text_danger">*</span></label>
                  <textarea rows="5" id="txtTicketDescription" name="customer_replay_message" placeholder="<?php esc_html_e('توضیحات', 'woodmartplus'); ?>"></textarea>
               </div>
               <div class="ticket_images__uploaded">

                  <div class="avatar_image">

                  </div>
                  <div id="uploaded-files-list" class="uploaded-files-list">
                  </div>
               </div>
            <?php if( wplus_helper::get_setting('upload_ticket_file') ): ?>
               <label for="uploaderTicket" class="upload_image__button">
                  <input id="uploaderTicket" type="file" name="uploadTicket[]" multiple>
                  <span type="button" data-multiple="true">
                     <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21" fill="none">
                        <path d="M13.6997 7.91602C16.6997 8.17435 17.9247 9.71602 17.9247 13.091V13.1993C17.9247 16.9243 16.4331 18.416 12.7081 18.416H7.28307C3.55807 18.416 2.06641 16.9243 2.06641 13.1993V13.091C2.06641 9.74102 3.27474 8.19935 6.22474 7.92435" stroke="#4D4D4D" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                        <path d="M10 13.0009V3.51758" stroke="#4D4D4D" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                        <path d="M12.7913 5.37565L9.99967 2.58398L7.20801 5.37565" stroke="#4D4D4D" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                     </svg>
                     <p><?php esc_html_e('آپلود فایل', 'woodmartplus'); ?></p>
                  </span>
               </label>
            <?php endif; ?>
               <div class="justify_end">
                  <button type="submit" class="btn solid medium" name="customer_send_replay_message">
                     <?php esc_html_e('ارسال تیکت', 'woodmartplus'); ?>
                  </button>
               </div>
            </form>
         </div>
      <?php else: ?>
         <h3><?php esc_html_e('این تیکت به حالت بسته در آمده ، لطفا یک تیکت جدید باز کنید', 'woodmartplus'); ?></h3>
      <?php endif; ?>
   </div>
</div>
<script>
   document.addEventListener('DOMContentLoaded', function() {
      const fileInput = document.getElementById('uploaderTicket');
      const filesList = document.getElementById('uploaded-files-list');

      function updateFileInput(files) {
         const dataTransfer = new DataTransfer();
         for (let i = 0; i < files.length; i++) {
            dataTransfer.items.add(files[i]);
         }
         fileInput.files = dataTransfer.files;

         displayFiles();
      }

      function displayFiles() {
         filesList.innerHTML = '';

         if (fileInput.files.length > 0) {
            for (let i = 0; i < fileInput.files.length; i++) {
               const file = fileInput.files[i];
               const fileItem = document.createElement('div');
               fileItem.className = 'file-item';

               const fileName = document.createElement('span');
               fileName.className = 'file-name';
               fileName.textContent = file.name;

               const removeBtn = document.createElement('button');
               removeBtn.className = 'remove-file';
               removeBtn.innerHTML = '&times;';
               removeBtn.type = 'button';
               removeBtn.dataset.index = i;
               removeBtn.addEventListener('click', function() {
                  const files = Array.from(fileInput.files);
                  files.splice(i, 1);
                  updateFileInput(files);
               });

               fileItem.appendChild(fileName);
               fileItem.appendChild(removeBtn);
               filesList.appendChild(fileItem);
            }
         }
      }

      fileInput.addEventListener('change', function() {
         displayFiles();
      });
   });
</script>
<style>
   .uploaded-files-list {
      margin-top: 10px;
   }

   .file-item {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 5px 10px;
      margin-bottom: 5px;
      background-color: #f5f5f5;
      border-radius: 4px;
   }

   .file-name {
      flex-grow: 1;
      margin-right: 10px;
   }

   .remove-file {
      background: none;
      border: none;
      color: #ff0000;
      cursor: pointer;
      font-size: 18px;
      font-weight: bold;
   }
</style>