<!-- Waitlist Table Template -->
<div class="waitlist-container" id="waitlist-container">
    <div class="waitlist-header">
        <h2 class="waitlist-title"><?php esc_html_e('لیست انتظار من','woodmartplus') ?></h2>
        <p class="waitlist-subtitle"><?php esc_html_e('محصولاتی که منتظر موجود شدن آنها هستید','woodmartplus'); ?></p>
    </div>

    <!-- AJAX Loader Overlay -->
    <div class="waitlist-loader-overlay" id="waitlist-loader-overlay" style="display: none;">
        <div class="waitlist-loader-spinner">
            <div class="spinner-circle"></div>
            <div class="spinner-circle"></div>
            <div class="spinner-circle"></div>
        </div>
        <p class="loader-text"><?php esc_html_e('در حال پردازش...','woodmartplus') ?></p>
    </div>

    <!-- Table Wrapper -->
    <div class="waitlist-table-wrapper">
        <table class="waitlist-table" id="waitlist-table">
            <thead>
                <tr>
                    <th class="th-image"><?php esc_html_e('تصویر محصول','woodmartplus'); ?></th>
                    <th class="th-name"><?php esc_html_e('نام محصول','woodmartplus') ?></th>
                    <th class="th-name"><?php esc_html_e('موجودی محصول','woodmartplus') ?></th>
                    <th class="th-status"><?php esc_html_e('موجودی محصول','woodmartplus') ?></th>
                    <th class="th-action"><?php esc_html_e('عملیات','woodmartplus') ?></th>
                </tr>
            </thead>
            <tbody id="waitlist-tbody">
                 <?php foreach( $waitlists as $waitlist ): ?>
                    <tr class="waitlist-row" data-item-id="1">
                        <td class="td-image">
                            <div class="product-image-wrapper">
                                <?php echo $waitlist['product_image'] ?>
                            </div>
                        </td>
                        <td class="td-name">
                            <a href="<?php echo $waitlist['product_url']  ?>" class="product-name-link">
                                <span class="product-name"><?php echo $waitlist['product_name']  ?></span>
                            </a>
                        </td>
                        <td class="td-name">
                            <div>
                                <span class="product-name"><?php echo $waitlist['product_status'];  ?></span>
                            </div>
                        </td>
                        <td class="td-status">
                            <span class="sms-status-badge <?php echo $waitlist['sended'] ? 'status-active' : 'status-inactive' ?>">
                                <span class="status-text"><?php echo $waitlist['sended_sms']  ?></span>
                            </span>
                        </td>
                        <td class="td-action">
                            <button class="btn-remove" data-item-id="<?php echo $waitlist['row_id']  ?>">
                                <span class="btn-remove-icon">🗑️</span>
                                <span class="btn-remove-text"><?php esc_html_e('حذف','woodmartplus') ?></span>
                            </button>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>

        <div class="waitlist-empty" id="waitlist-empty" style="display: none;">
            <div class="empty-icon">📋</div>
            <h3 class="empty-title"><?php esc_html_e('لیست انتظار شما خالی است','woodmartplus') ?></h3>
            <p class="empty-description"><?php esc_html_e('هنوز محصولی به لیست انتظار خود اضافه نکرده اید','woodmartplus') ?></p>
            <a href="<?php echo wc_get_page_permalink( 'shop' ) ?>" class="empty-link"><?php esc_html_e('مشاهده محصولات','woodmartplus') ?></a>
        </div>
    </div>
</div>
